﻿using Hims.Api.Models;
using Hims.Api.Utilities;
using Hims.Domain.Services;
using Hims.Shared.DataFilters;
using Hims.Shared.EntityModels;
using Hims.Shared.Library.Enums;
using Hims.Shared.UserModels;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using System;
using System.Collections.Generic;
using System.Threading.Tasks;

namespace Hims.Api.Controllers
{
    [Route("api/whatsapp-tickets")]
    [ApiController]
    public class WhatsAppTicketController : BaseController
    {
        /// <summary>
        /// The Tpa Service
        /// </summary>

        private readonly IWhatsAppTicketsService service;
        /// <summary>
        /// The AuditLog Service
        /// </summary>
        private readonly IAuditLogService auditLogServices;



        /// <inheritdoc />
        public WhatsAppTicketController(IWhatsAppTicketsService service, IAuditLogService auditLogServices)
        {
            this.service = service;
            this.auditLogServices = auditLogServices;
        }

        /// <summary>
        /// The Get All WhatsAppTickets.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        [HttpPost]
        [Route("get-alltickets")]
        public async Task<ActionResult> GetAllWhatsAppTickets([FromBody] WhatsAppTicketsModel model)
        {
            model = (WhatsAppTicketsModel)EmptyFilter.Handler(model);
            var result = await service.GetAllWhatsAppTickets(model);
            return Ok(result);
        }
        /// <summary>
        /// The Change Status.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        [HttpPut]
        [Route("ChangeStatus")]
        public async Task<ActionResult> ChangeStatus([FromBody]WhatsAppTicketsModel model, [FromHeader] LocationHeader location)
        {
            model = (WhatsAppTicketsModel)EmptyFilter.Handler(model);
            var result = await service.ChangeStatus(model);
            if (result > 0)
            {
                var auditLogModel = new AuditLogModel
                {
                    AccountId = model.ModifiedBy,
                    LogTypeId = (int)LogTypes.WhatsAppTickets,
                    LogFrom = (short)model.LoginRoleId,
                    LogDate = DateTime.UtcNow.AddMinutes(330),
                    LogDescription = $" {model.ModifiedByName} has {((bool)model.Solved ? "Unsolved" : "Solved")}  WhatsApp Ticket  - <b>{model.Name}</b> on {DateTime.UtcNow.AddMinutes(330).ToString("dd/MM/yyyy, hh:mm tt")}",
                    LocationId = Convert.ToInt32(location.LocationId)
                };
                await this.auditLogServices.LogAsync(auditLogModel);
            }
            
            return Ok(result);
        }


    }
}
